<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PeopleService;

class ContactGroupMetadata extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * Output only. True if the contact group resource has been deleted. Populated
     * only for [`ListContactGroups`](/people/api/rest/v1/contactgroups/list)
     * requests that include a sync token.
     *
     * @var bool
     */
    public $deleted;
    /**
     * Output only. The time the group was last updated.
     *
     * @var string
     */
    public $updateTime;
    /**
     * Output only. True if the contact group resource has been deleted. Populated
     * only for [`ListContactGroups`](/people/api/rest/v1/contactgroups/list)
     * requests that include a sync token.
     *
     * @param bool $deleted
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
    }
    /**
     * @return bool
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Output only. The time the group was last updated.
     *
     * @param string $updateTime
     */
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    /**
     * @return string
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\ContactGroupMetadata::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PeopleService_ContactGroupMetadata');
